<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('area_id', 'name', 'user_name', 'password', 'phone', 'cash_balance', 'winning_balance', 'user_type');

    public function userArea()
    {
        return $this->belongsTo('Area', 'area_id');
    }

}